function [local_peaks, peak_indices, local_min, min_indices] = find_local_peaks(data_vector, threshold)

local_peaks = [];
peak_indices = [];

local_min = [];
min_indices = [];

size_vec = size(data_vector);
if( min(size_vec) ~= 1)
    disp(' Give a one dimensional vector');
    return;
end

bin_vec = data_vector > threshold;
temp_vec = bin_vec(2:length(bin_vec)) - bin_vec(1:length(bin_vec)-1);

start_positions = 1 + find(temp_vec  == 1);
stop_positions = 1 + find( temp_vec == -1);

% check for the first position
if (bin_vec(1) == 1)
    start_positions = [1 start_positions(:)'];
    stop_positions = stop_positions(:)';
else
    start_positions = start_positions(:)';
    stop_positions = [1 stop_positions(:)'];
end

% ignore the first bit if its negative
if (start_positions(1) > stop_positions(1))
    stop_positions = stop_positions(2:length(stop_positions));
end

% ignore the last bit
if (start_positions(length(start_positions)) > stop_positions(length(stop_positions)))
    stop_positions = [stop_positions length(bin_vec)];
end

% Now check for each part between a start and a stop to find the maxima
for part_index = 1:length(start_positions)
    [temp_max, temp_ind] = max(data_vector( start_positions(part_index):stop_positions(part_index)));
    local_peaks = [local_peaks temp_max];
    peak_indices = [peak_indices temp_ind+start_positions(part_index)-1];
end
    

% Now check for each part between a stop and a start to find the minima
for part_index = 1:min(length(stop_positions), length(start_positions))-1
    [temp_min, temp_ind] = min(data_vector( stop_positions(part_index):start_positions(part_index+1)));
    local_min = [local_min temp_min];
    min_indices = [min_indices temp_ind+stop_positions(part_index)-1];
end

% plot(bin_vec);
hold on;
plot(data_vector, 'g')
plot(1:length(data_vector), threshold, 'k--');
% stem(start_positions, ones(1,length(start_positions)), 'r');
% stem(stop_positions, ones(1, length(stop_positions)), 'g');
plot(peak_indices, local_peaks, 'r*');
%plot(min_indices, local_min, '*');
box on ;
grid on;
xlabel('Time');
ylabel('Voltage');
%disp (peak_indices); %uncomment this to get the index values for the peaks
axis([0 length(data_vector) min(data_vector)-.5 max(data_vector)+.5])